#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=icon.ico
#AutoIt3Wrapper_Outfile=./rasautodialer.exe
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_Comment=STG RAS Auto Dialer - Controls a RAS dialup connection, will log the results to a file, sleeps on startup and run a command if not connected in X minutes.
#AutoIt3Wrapper_Res_Description=STG RAS Auto Dialer - AutoConnector for RAS Connections (Wireless Broadband, VPN and dialup).
#AutoIt3Wrapper_Res_Fileversion=0.13.6.26
#AutoIt3Wrapper_Res_LegalCopyright=Secure Technology Group Pty Ltd (Australia)
#AutoIt3Wrapper_Res_SaveSource=y
#AutoIt3Wrapper_Res_requestedExecutionLevel=asInvoker
#AutoIt3Wrapper_Res_Field=Support Website|Your Tech Support (www.yts.com.au)
#AutoIt3Wrapper_Res_Icon_Add=.\green.ICO
#AutoIt3Wrapper_Res_Icon_Add=.\orange.ICO
#AutoIt3Wrapper_Res_Icon_Add=.\red.ICO
#AutoIt3Wrapper_Run_Tidy=y
#Obfuscator_Parameters=/striponly
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include <Process.au3>
#include <Date.au3>
#include <Crypt.au3>
;#include "InetCon.au3"

Global $AppIni = @ScriptDir & "\rasautodialer.ini", $DebugLevel = 10
; the following is used for encryping username & password in INI file
Const $sUserKey = "CryptPassword#1HLS"
;Global $NetworkConnectionPromptTitle = IniRead($AppIni, "Common", "NetConnectPromptName", "Network Connection Prompt")
Global $INI_DisableTips = IniRead($AppIni, "Common", "DisableTips", "0")
Global $INI_EnableDebug = IniRead($AppIni, "Common", "EnableDebug", "0")
Global $INI_DebugLog = IniRead($AppIni, "Common", "DebugLog", "0")
Global $INI_RasDialerTitle = IniRead($AppIni, "Common", "RasDialerTitle", "")
Global $INI_DialupName = IniRead($AppIni, "Common", "RasDialConnectionName", "")
Global $INI_DialOnNetwork = IniRead($AppIni, "Common", "DialOnNetwork", 1)
Global $INI_NotConnectedActionTime = IniRead($AppIni, "Common", "NotConnectedActionTime", 10)
Global $INI_NotConnectedAction = IniRead($AppIni, "Common", "NotConnectedAction", "")
Global $INI_DialupUserName = IniRead($AppIni, "Common", "RasDialConnectionUser", "")
Global $INI_DialupPass = IniRead($AppIni, "Common", "RasDialConnectionPass", "")
Global $INI_SleepSeconds = IniRead($AppIni, "Common", "ConnectionCheckSeconds", "")

If Not FileExists($AppIni) Then
	MsgBox(0, "RAS uto Dialer", "Welcome to SecureTechs RAS Auto Dialer" & @CRLF & @CRLF & "This Application establishes & Maintains a RAS connection." & @CRLF & "RAS connections are used as dialup connections, Wireless Broadband Connections & VPN Connections" & @CRLF & @CRLF & "the following steps you through the options to setup this application")
	FileWrite($AppIni, "#this is the INI for 'rasautodialer.exe' available at www.securetech.com.au")

	$INI_RasDialerTitle = InputBox("RAS Auto Dialer", "Enter the title to be shown when the " & @ScriptName & " Application is run." & @CRLF & @CRLF & "Default should be fine if in doubt", "RAS Dialer")
	FileWrite($AppIni, ";Title to use for 'rasautodialer.exe' GUI & tray items")
	IniWrite($AppIni, "Common", "RasDialerTitle", $INI_RasDialerTitle)
	;	$INI_RasDialerTitle = InputBox("RAS Dialer", "Enter the name for this App" & @CRLF & @CRLF & "example = 'Wireless Broadband Control' or 'VPN Dialer'","RAS Dialer")
	;	IniWrite($AppIni, "Common", "AppName", $INI_RasDialerTitle)

	$INI_DialupName = InputBox($INI_RasDialerTitle, "Enter your rasdial entryname (exactly) ...")
	FileWrite($AppIni, ";The RASDIAL entryname to connect to ...")
	IniWrite($AppIni, "Common", "RasDialConnectionName", $INI_DialupName)

	$INI_DialupUserName = _Crypt_EncryptData(InputBox($INI_RasDialerTitle, "Enter your RAS account UserName ..." & @CRLF & @CRLF & "(Note: Username is stored encrypted)"), $sUserKey, $CALG_RC4)
	FileWrite($AppIni, ";This is the encrypted version of the suplied username")
	IniWrite($AppIni, "Common", "RasDialConnectionUser", $INI_DialupUserName)

	$INI_DialupPass = _Crypt_EncryptData(InputBox($INI_RasDialerTitle, "Enter your RAS account Password ..." & @CRLF & @CRLF & "(Note: Password is stored encrypted)", "", "#"), $sUserKey, $CALG_RC4)
	FileWrite($AppIni, ";This is the encrypted version of the suplied Password")
	IniWrite($AppIni, "Common", "RasDialConnectionPass", $INI_DialupPass)

	$INI_DialOnNetwork = MsgBox(4, $INI_RasDialerTitle, "Do you want to dial even when a LAN is detected ?" & @CRLF & @CRLF & "Handy for laptops to not dial when a LAN (wireless or wired) is detected.")
	If $INI_DialOnNetwork = 6 Then
		$INI_DialOnNetwork = 1
	Else
		$INI_DialOnNetwork = 0
	EndIf
	FileWrite($AppIni, ";If DialOnNetwork=1 then the system will dial even if a LAN (wifi or wired) is detected, else it will not - good for mobile workforce.")
	IniWrite($AppIni, "Common", "DialOnNetwork", $INI_DialOnNetwork)

	$INI_SleepSeconds = InputBox($INI_RasDialerTitle, "How many seconds do you want the app to wait between checking for WAN connections " & @CRLF & "(Max Disconnected Time)", "15")
	FileWrite($AppIni, ";How long to sleep before checking if the connection is still active ?")
	IniWrite($AppIni, "Common", "ConnectionCheckSeconds", $INI_SleepSeconds)

	$INI_NotConnectedActionTime = InputBox($INI_RasDialerTitle, "How many minutes do you want the app to wait before performing an action ?" & @CRLF & @CRLF & "Action example to reboot would be: 'shutdown /r /f'", "60")
	IniWrite($AppIni, "Common", "NotConnectedActionTime", $INI_NotConnectedActionTime)

	$INI_NotConnectedAction = InputBox($INI_RasDialerTitle, "What action do you want to perform if not connected in " & $INI_NotConnectedActionTime & " Minutes ?" & @CRLF & @CRLF & "Action example to reboot would be: 'shutdown /r /f'" & @CRLF & @CRLF & "Leave blank for no action ...")
	IniWrite($AppIni, "Common", "NotConnectedAction", "")

	$INI_DisableTips = MsgBox(4, $INI_RasDialerTitle, "Do you want to disable:" & @CRLF & @CRLF & "Traytips - which inform you when connection lost & redialing ?" & @CRLF & "Tooltips - which inform each minute, how long this connection has stayed connected ?")
	If $INI_DisableTips = 6 Then
		$INI_DisableTips = 1
	Else
		$INI_DisableTips = 0
	EndIf
	IniWrite($AppIni, "Common", "DisableTips", $INI_DisableTips)

	;	$INI_EnableDebug = MsgBox(4, $INI_RasDialerTitle, "Do you want to enable debug logging?" & @CRLF & "This will write a log file into the directory & output debug info to debugview")
	;	If $INI_EnableDebug = 6 Then
	;		$INI_EnableDebug = 1
	;	Else
	$INI_EnableDebug = 0
	;	EndIf
	FileWrite($AppIni, ";If EnableDebug=1 then debugviewer.exe can be used to see output.")
	IniWrite($AppIni, "Common", "EnableDebug", $INI_EnableDebug)


	FileWrite($AppIni, ";If DebugLog=1 then output will be logged to a file (EnableDebug=1 must also be on).")
	IniWrite($AppIni, "Common", "DebugLog", "0")

EndIf
If $INI_SleepSeconds > 1 Then
	$INI_SleepSeconds = $INI_SleepSeconds - 1
EndIf

If $INI_NotConnectedActionTime < 1 Then
	$INI_NotConnectedActionTime = 30
EndIf

Global $DoExit = 0, $DoConnectionRetries, $sTimestamp[3], $DoActivateRetries = 0, $ConnectionState = "Launch", $WBTControlHandle, $TrayMin[3], $LastTrayMin, $Days, $Hours, $Mins, $Secs, $YTS_EventDisplay, $LastTrayTip, $INetCon, $RetINetConnect, $DisconnectSeconds, $Silent
Global $HelpMsg = ""
Global $YTS_ProcessID
Global $ConnectedForLong, $ConnectedForShort
$sTimestamp[1] = _NowCalc()
$sTimestamp[2] = _NowCalc() ;sleep for 10 more seconds

#region Commandline
If $cmdline[0] > 0 Then
	YTS_EventLog("CmdLine Arguements Found", $YTS_EventDisplay, "1")
	_cmdline()
Else
	YTS_EventLog("No CmdLine", $YTS_EventDisplay, "1")
EndIf
#endregion Commandline

#region Setup autoit options
Opt("WinWaitDelay", 100)
Opt("WinTitleMatchMode", 4)
Opt("WinDetectHiddenText", 1)
Opt("MouseCoordMode", 0)
Opt("TrayAutoPause", 0)
Opt("TrayIconDebug", 1) ;If enabled shows the current script line in the tray icon tip to help debugging.		0 = no debug information (default)	1 = show debug
OnAutoItExitRegister("OnAutoItExit")
#endregion Setup autoit options

#region TrayState
_TrayIconState()
If @Compiled Then
	TraySetPauseIcon(@ScriptFullPath, 6)
EndIf
#endregion TrayState


If _MutexExists($INI_RasDialerTitle & " Control") Then
	; We know the script is already running. Let the user know.
	$return = MsgBox(1, $INI_RasDialerTitle & " Control", "This Application has already been started once" & @CRLF & @CRLF & "If you want to open another copy, click 'OK'," & @CRLF & "Otherwise this duplicate will close automagically in 10 seconds", 10)
	If $return = -1 Or $return = 2 Then
		Exit (1)
	EndIf
EndIf

If $INI_DebugLog = 1 Or StringInStr($CmdLineRaw, "-debuglog") Then
	$INI_DebugLog = 1
	If FileExists(@ScriptFullPath & "_" & @YEAR & @MON & @MDAY & "_LOG.txt") Then
		$return = MsgBox(1, @ScriptName, "Log File Exists:" & @CRLF & "'" & @ScriptFullPath & "_" & @YEAR & @MON & @MDAY & "_LOG.txt'" & @CRLF & @CRLF & "Log will now be deleted ...", 10)
		If $return = 1 Or $return = -1 Then
			FileDelete(@ScriptFullPath & "_" & @YEAR & @MON & @MDAY & "_LOG.txt")
		EndIf
	EndIf
EndIf

If $INI_DialOnNetwork = "1" Then
	If Not StringInStr(_GetNetworkConnect(), "WAN", 2) Then
		If $INI_DisableTips <> "1" Then TrayTip($INI_RasDialerTitle & " Control", "Starting ...", 10)
		MsgBox(48, $INI_RasDialerTitle & " Control", "There is no WAN connection" & @CRLF & @CRLF & "Lets start one eh ...", 5)
	EndIf
Else
	If Not StringInStr(_GetNetworkConnect(), "LAN", 2) Then
		If $INI_DisableTips <> "1" Then TrayTip($INI_RasDialerTitle & " Control", "Starting ...", 10)
		MsgBox(48, $INI_RasDialerTitle & " Control", "There is no WAN connection" & @CRLF & @CRLF & "Lets start one eh ...", 5)
	EndIf
EndIf

$TrayMenuTips = TrayCreateItem("Silence Tips")
TraySetState()

Do; Pseudo loop
	If _NowCalc() > $sTimestamp[1] Then
		$YTS_EventDisplay = YTS_EventLog("$ConnectionState = " & $ConnectionState, $YTS_EventDisplay, 8)
		$YTS_EventDisplay = YTS_EventLog("$sTimestamp[1] = '" & $sTimestamp[1] & "' $INI_DialOnNetwork = '" & $INI_DialOnNetwork & "' _GetNetworkConnect() = '" & _GetNetworkConnect() & "'", $YTS_EventDisplay, 9)
		If StringInStr(_GetNetworkConnect(), "LAN", 2) And $INI_DialOnNetwork <> "1" Then
			$YTS_EventDisplay = YTS_EventLog("LAN Connection detected & DialOnNetwork <> 1, so lets sleep", $YTS_EventDisplay, 1)
			$sTimestamp[1] = _DateAdd('s', $INI_SleepSeconds, _NowCalc()) ;sleep for 10 seconds
		ElseIf Not StringInStr(_GetNetworkConnect(), "WAN", 2) Then ;if no WAN connection established then ...
			YTS_EventLog("WAN Connection NOT detected", $YTS_EventDisplay, 1)
			$sTimestamp[1] = _NowCalc() ;sleep for 1 seconds
			If $ConnectionState <> "NO" And $ConnectionState <> "Dialing" Then ; if connection state is anything but "NO" then if the WAN connection has just closed
				$YTS_EventDisplay = YTS_EventLog("$ConnectionState = " & $ConnectionState, $YTS_EventDisplay, 9)
				_TrayIconState($ConnectionState)
				If @Compiled Then TraySetToolTip("SecureTech.com.au " & @ScriptName & " - " & FileGetVersion(@ScriptFullPath))

				YTS_EventLog($INI_RasDialerTitle & " - Was " & _ConnectedToolTips(), $YTS_EventDisplay, 1)
				$YTS_EventDisplay = YTS_EventLog("$ConnectionState = " & $ConnectionState, $YTS_EventDisplay, 9)
				$ConnectionState = "NO" ;so we don't re-run while still disconnected
				$DisconnectTicks = _TimeToTicks(@HOUR, @MIN, @SEC) ;$DisconnectTicks = now
				$ExitTicks = $DisconnectTicks + $INI_NotConnectedActionTime * 60 * 1000 ; make $ExitTicks ten minutes in advance ...
			Else
				$YTS_EventDisplay = YTS_EventLog("Dialing '" & $INI_DialupName & "' Connection ...", $YTS_EventDisplay, 1)
				;				If $INI_DisableTips <> "1" Then TrayTip($INI_RasDialerTitle & " Control", "Dialing '" & $INI_DialupName & "' Connection ...", 10)
				$ConnectionState = "Dialing"
				_TrayIconState($ConnectionState)
				;				_ChangeTrayIcon("orange")
				;				TraySetState(4) ;flash the trayicon (stops flashing when connected)
				$RetINetConnect = _INetConnect($INI_DialupName, $INI_DialupUserName, $INI_DialupPass)
				$YTS_EventDisplay = YTS_EventLog($INetCon, $YTS_EventDisplay, 6)
				If $RetINetConnect = 0 Then
					_TrayIconState("DialFailed")
				Else
					TrayTip($INI_RasDialerTitle & " Control", "", 10)
				EndIf
				;				Sleep(5000)
				$DisconnectSeconds = (_TimeToTicks(@HOUR, @MIN, @SEC) - $DisconnectTicks) / 1000

				If _TimeToTicks(@HOUR, @MIN, @SEC) > $ExitTicks Then
					$INI_NotConnectedAction = IniRead($AppIni, "Common", "NotConnectedAction", "")
					$YTS_EventDisplay = YTS_EventLog("NO connection made in " & $INI_NotConnectedActionTime & " Minutes ... Perfomring the following Action Now: " & $INI_NotConnectedAction, $YTS_EventDisplay, 1)
					Run($INI_NotConnectedAction)
					$ExitTicks = _TimeToTicks(@HOUR, @MIN, @SEC) + $INI_NotConnectedActionTime * 60 * 1000 ; make $ExitTicks ten minutes in advance ...

				EndIf
			EndIf

		Else
			$sTimestamp[1] = _DateAdd('s', $INI_SleepSeconds, _NowCalc()) ;sleep for 10 seconds
			;			$sTimestamp[1] = _NowCalc()
			$iTicks = _TimeToTicks()
			If $ConnectionState <> "Connected" Then
				$ConnectionState = "Connected" ;so we don't re-run while still connected
				_TrayIconState($ConnectionState)
				$YTS_EventDisplay = YTS_EventLog("$ConnectionState = " & $ConnectionState, $YTS_EventDisplay, 9)
				$ConnectedTicks = _TimeToTicks() ;$ConnectedTicks = now
				$ConnectedMin = @MIN
				$CurrentTicks = $iTicks + 60000
			ElseIf $iTicks >= $CurrentTicks Then
				$CurrentTicks = $iTicks + 60000
				;				$DifTime = _TicksToTime(_TimeToTicks() - $ConnectedTicks, $Hours, $Mins, $Secs)
				YTS_EventLog($INI_RasDialerTitle & " - " & _ConnectedToolTips(), $YTS_EventDisplay, 9)
				;				YTS_EventLog($INI_RasDialerTitle & " - Connected for " & $Hours & " Hours, " & $Mins & " Minutes", $YTS_EventDisplay, 1)
				;				$ToolTipTime = " - Up for " & $Hours & ":" & $Mins & " (Hrs:Min)"
				_TrayIconState($ConnectionState)

				TraySetToolTip("SecureTech.com.au " & @ScriptName & " - " & _ConnectedToolTips("Short"))
				If $INI_DisableTips <> "1" Then
					ToolTip($INI_RasDialerTitle & " - " & $ConnectedForLong)
					Sleep(2000)
					ToolTip("")
				EndIf

			EndIf
		EndIf
	EndIf
	; Tray Menu
	Switch TrayGetMsg()
		Case $TrayMenuTips
			YTS_EventLog($INI_RasDialerTitle & " - Tray - $TrayMenuTips clicked", $YTS_EventDisplay, 7)
			If $INI_DisableTips <> "1" Then
				YTS_EventLog($INI_RasDialerTitle & " - Tray - $INI_DisableTips <> '1'", $YTS_EventDisplay, 8)
				$INI_DisableTips = "1"
				; mark tray item as ticked
				TrayItemSetState($TrayMenuTips, 1) ;$TRAY_CHECKED = 1, $TRAY_UNCHECKED = 4, $TRAY_ENABLE = 64, $TRAY_DISABLE = 128, $TRAY_FOCUS = 256, $TRAY_DEFAULT = 512
			Else
				YTS_EventLog($INI_RasDialerTitle & " - Tray - $INI_DisableTips = '1'", $YTS_EventDisplay, 8)
				$INI_DisableTips = "0"
				; mark tray item as ticked
				TrayItemSetState($TrayMenuTips, 4) ;$TRAY_CHECKED = 1, $TRAY_UNCHECKED = 4, $TRAY_ENABLE = 64, $TRAY_DISABLE = 128, $TRAY_FOCUS = 256, $TRAY_DEFAULT = 512
			EndIf
	EndSwitch
	Sleep(50)
Until $DoExit = 1

Func _ConnectedToolTips($Length = "Long")
	YTS_EventLog("Func _ConnectedToolTips()", $YTS_EventDisplay, 7)
	;	Local $Days, $Hours, $Mins

	If _DateDiff('D', $sTimestamp[2], _NowCalc()) >= 1 Then
		$Days = _DateDiff('D', $sTimestamp[2], _NowCalc())
		$Hours = (_DateDiff('h', $sTimestamp[2], _NowCalc()) - ($Days * 24))
		$Mins = (_DateDiff('n', $sTimestamp[2], _NowCalc()) - ($Hours * 60))
		$ConnectedForLong = $INI_RasDialerTitle & " - Connected for: " & $Days & " Days, " & $Hours & " Hours, " & $Mins & " Mins."
		$ConnectedForShort = "Connected: " & $Days & "D, " & $Hours & ":" & $Mins
	ElseIf _DateDiff('h', $sTimestamp[2], _NowCalc()) >= 1 Then
		$Hours = _DateDiff('h', $sTimestamp[2], _NowCalc())
		$Mins = (_DateDiff('n', $sTimestamp[2], _NowCalc()) - ($Hours * 60))
		$ConnectedForLong = $INI_RasDialerTitle & " - Connected for: " & $Hours & " Hours, " & $Mins & " Mins."
		$ConnectedForShort = "Connected: " & $Hours & ":" & $Mins
	Else
		$Mins = _DateDiff('n', $sTimestamp[2], _NowCalc())
		$ConnectedForLong = $INI_RasDialerTitle & " - Connected for: " & $Mins & " Mins."
		$ConnectedForShort = "Connected: " & $Mins & " Mins."
		;		$sTimestamp[2] = _DateAdd('s', 59, _NowCalc()) ;sleep for 1 more minute
	EndIf
	;	YTS_EventLog($ConnectedForLong, $YTS_EventDisplay, 1)
	If $Length = "Long" Then
		Return $ConnectedForLong
	Else
		Return $ConnectedForShort
	EndIf
EndFunc   ;==>_ConnectedToolTips

Func _WBDial($Local_ConnectionName)
	YTS_EventLog("Func _WBDial(" & $Local_ConnectionName & ")", $YTS_EventDisplay, 7)
	_TrayIconState($ConnectionState)
	_INetConnect($Local_ConnectionName, $INI_DialupUserName, $INI_DialupPass)
EndFunc   ;==>_WBDial

; #FUNCTION# ====================================================================================================================
; Name...........: _IniReadWrite
; Description ...: Reads a value from a standard format .ini file. If returned value = "" it writes default value to INI.
;		If no default given, it writes a space (which should mean it doesn't return back
; Syntax.........: _IniReadWrite ($LocalFilename, $LocalSection, $LocalKey, $LocalDefault = ' ')
;
; Parameters ....:	$LocalFilename -	The filename of the .ini file.
;					$LocalSection -		The section name in the .ini file.
;					$LocalKey -			The key name in the in the .ini file.
;					$LocalDefault -		The default value to return (and write to INI) if the requested key is not found.
;
; Return values .:	Success -			Returns the requested key value read from INI. ($LocalRead)
;					Failure -			Returns the default string if requested key not found. ($LocalDefault)
;										Writes the $LocalDefault
; Author ........:	JDaus
; ===============================================================================================================================
Func _IniReadWrite($LocalFilename, $LocalSection, $LocalKey, $LocalDefault = ' ')
	YTS_EventLog("Func _IniReadWrite(" & $LocalFilename & ", " & $LocalSection & ", " & $LocalKey & ", " & $LocalDefault & ")", "", "7")
	Local $LocalRead, $LocalWrite, $return
	$LocalRead = IniRead($LocalFilename, $LocalSection, $LocalKey, '')
	If $LocalRead = '' Then
		SetError(1)
		$LocalWrite = IniWrite($LocalFilename, $LocalSection, $LocalKey, $LocalDefault)
		If $LocalWrite = 0 Then
			$return = 0
		Else
			$return = $LocalDefault
		EndIf
	Else
		$return = $LocalRead
	EndIf
	Return $return
EndFunc   ;==>_IniReadWrite

;===============================================================================
;
; Description:          Eventlog handler, sends logs to std windows debug (via dll)
;                                       and GUI Statusbars
; Parameter(s):         $YTS_EventLog   =       Text string to send to log
;                       $LocalDbgLvl	=		0, text is display in statusbar. else, only sent to debug dll
; Requirement(s):
; Return Value(s):      $YTS_EventDisplay
; Author(s):            YTS_Jim
; Note(s):
;
;===============================================================================
Func YTS_EventLog($YTS_EventLog = '', $YTS_EventDisplay = '', $LocalDbgLvl = '8')
	;	Local $DebugLevel
	If $DebugLevel > $LocalDbgLvl Then
		If $YTS_EventLog <> $YTS_EventDisplay Then
			If $INI_EnableDebug Then
				; view the following output from sysinternals debuger "DebugView" or similar
				DllCall("kernel32.dll", "none", "OutputDebugString", "str", "YTS - " & $YTS_EventLog)
				ConsoleWrite($YTS_EventLog & @CRLF)
				$YTS_EventDisplay = $YTS_EventLog
			EndIf
			If $INI_DebugLog = 1 Or StringInStr($CmdLineRaw, "-debuglog") Then FileWrite(@ScriptFullPath & "_" & @YEAR & @MON & @MDAY & "_LOG.txt", _NowCalc() & " - " & $YTS_EventLog & @CRLF)
		EndIf
	EndIf

	Return $YTS_EventDisplay
EndFunc   ;==>YTS_EventLog

Func OnAutoItExit()
	YTS_EventLog($INI_RasDialerTitle & " - Exiting ..." & @CRLF, $YTS_EventDisplay, 1)
	If $INI_DisableTips <> "1" Then TrayTip($INI_RasDialerTitle, "Exiting ...", 60)
	If @exitCode < 4 Then
		If (MsgBox(4, $INI_RasDialerTitle & " Control", "Do You want to Disconnect and close the '" & $INI_RasDialerTitle & " Control' Application as well ???", 20) = 6) Then
			_ChangeTrayIcon("red")
			_INetDisconnect($INI_DialupName)
			$DoConnectionRetries = 0
		EndIf
	Else
		_ChangeTrayIcon("red")
		_INetDisconnect($INI_DialupName)
	EndIf
EndFunc   ;==>OnAutoItExit

Func _ChangeTrayIcon($IconName = "")
	YTS_EventLog("Func _ChangeTrayIcon(" & $IconName & ")", "", "7")
	If FileExists(@ScriptDir & "\" & $IconName & ".ICO") Then
		TraySetIcon(@ScriptDir & "\" & $IconName & ".ICO")
		If $IconName = "green" Then
			TraySetState(1 + 8) ;1 = Shows the tray icon (default), 2 = Destroys/Hides the tray icon, 4 = Flashes the tray icon, 8 = Stops tray icon flashing, 16 = Resets the icon to the defaults (no flashing, default tip text)
		ElseIf $IconName = "orange" Then
			TraySetState(4) ;1 = Shows the tray icon (default), 2 = Destroys/Hides the tray icon, 4 = Flashes the tray icon, 8 = Stops tray icon flashing, 16 = Resets the icon to the defaults (no flashing, default tip text)
		ElseIf $IconName = "red" Then
			TraySetState(4) ;1 = Shows the tray icon (default), 2 = Destroys/Hides the tray icon, 4 = Flashes the tray icon, 8 = Stops tray icon flashing, 16 = Resets the icon to the defaults (no flashing, default tip text)
		EndIf
	ElseIf @Compiled Then
		If $IconName = "green" Then
			TraySetIcon(@ScriptFullPath, -5)
			TraySetState(1 + 8) ;1 = Shows the tray icon (default), 2 = Destroys/Hides the tray icon, 4 = Flashes the tray icon, 8 = Stops tray icon flashing, 16 = Resets the icon to the defaults (no flashing, default tip text)
		ElseIf $IconName = "orange" Then
			TraySetIcon(@ScriptFullPath, -6)
			TraySetState(4) ;1 = Shows the tray icon (default), 2 = Destroys/Hides the tray icon, 4 = Flashes the tray icon, 8 = Stops tray icon flashing, 16 = Resets the icon to the defaults (no flashing, default tip text)
		ElseIf $IconName = "red" Then
			TraySetIcon(@ScriptFullPath, -7)
			TraySetState(4) ;1 = Shows the tray icon (default), 2 = Destroys/Hides the tray icon, 4 = Flashes the tray icon, 8 = Stops tray icon flashing, 16 = Resets the icon to the defaults (no flashing, default tip text)
		Else
			;			TraySetIcon(@ScriptDir & "\" & $WirelessBroadbandEXE)
		EndIf
	Else
		YTS_EventLog("ICON - Icon file '" & @ScriptDir & "\" & $IconName & ".ICO' not found & script not compiled", "", "8")
	EndIf
EndFunc   ;==>_ChangeTrayIcon
;http://www.autoitscript.com/forum/index.php?showtopic=49354
Func _INetConnect($Service, $Username = "", $Password = "")
	YTS_EventLog("Func _INetConnect(" & $Service & ", " & $Username & ", " & $Password & ")", "", "7")
	If $Username <> "" Then $Username = " " & BinaryToString(_Crypt_DecryptData($Username, $sUserKey, $CALG_RC4))
	If $Password <> "" Then $Password = " " & BinaryToString(_Crypt_DecryptData($Password, $sUserKey, $CALG_RC4))
	$YTS_ProcessID = Run(@SystemDir & '\rasdial.exe "' & $Service & '"' & $Username & $Password, @ScriptDir, @SW_HIDE, 7)
	;	YTS_EventLog('$YTS_ProcessID = Run(' & @SystemDir & '\rasdial.exe"' & $Service & '"' & $Username & $Password & ", @ScriptDir, @SW_HIDE, 7)")
	While ProcessExists("rasdial.exe")
		$INetCon = StdoutRead($YTS_ProcessID) ;V2M_SSH_OutCharsWaiting
		Select
			Case StringInStr($INetCon, "Remote Access error")
				Return 0
			Case StringInStr($INetCon, "Command completed successfully.")
				Return 1
		EndSelect
	WEnd
	Return -1
EndFunc   ;==>_INetConnect

Func _INetDisconnect($Service)
	YTS_EventLog("Func _INetDisconnect(" & $Service & ")", "", "7")
	$YTS_ProcessID = Run(@SystemDir & '\rasdial.exe "' & $Service & '" /DISCONNECT', @ScriptDir, @SW_HIDE, 7)
	;	YTS_EventLog('$YTS_ProcessID = Run(' & @SystemDir & '\rasdial.exe"' & $Service & '"' & $Username & $Password & ", @ScriptDir, @SW_HIDE, 7)")
	While ProcessExists("rasdial.exe")
		$INetCon = StdoutRead($YTS_ProcessID) ;V2M_SSH_OutCharsWaiting
		Select
			Case StringInStr($INetCon, "Command completed successfully.")
				Return 1
		EndSelect
	WEnd
	Return 0
EndFunc   ;==>_INetDisconnect

Func _INetStatus($Service)
	YTS_EventLog("Func _INetStatus(" & $Service & ")", "", "7")
	$YTS_ProcessID = Run(@SystemDir & '\rasdial.exe', @ScriptDir, @SW_HIDE, 7)
	While ProcessExists("rasdial.exe")
		$INetCon = StdoutRead($YTS_ProcessID) ;V2M_SSH_OutCharsWaiting
		Select
			Case StringInStr($INetCon, "No connections")
				Return 0 ;No connections @ all
			Case StringInStr($INetCon, "Connected to") And StringInStr($INetCon, $Service)
				Return 1 ;We are connected to something and the Service is in the name
		EndSelect
	WEnd
	Return 0;We are connected, but not to the Service asked
EndFunc   ;==>_INetStatus

Func _INetReconnect($Service, $Username, $Password)
	YTS_EventLog("Func _INetReconnect(" & $Service & ", " & $Username & ", " & $Password & ")", "", "7")
	If (_INetStatus($Service) = 1) Then _INetDisconnect($Service)
	If (_INetConnect($Service, $Username, $Password) = 0) Then Return 0
	Return 1
EndFunc   ;==>_INetReconnect

Func _MutexExists($sOccurenceName)
	YTS_EventLog("Func _MutexExists(" & $sOccurenceName & ")", "", "7")
	Local $ERROR_ALREADY_EXISTS = 183, $handle, $lastError

	$sOccurenceName = StringReplace($sOccurenceName, "\", ""); to avoid error
	$handle = DllCall("kernel32.dll", "int", "CreateMutex", "int", 0, "long", 1, "str", $sOccurenceName)

	$lastError = DllCall("kernel32.dll", "int", "GetLastError")
	Return $lastError[0] = $ERROR_ALREADY_EXISTS

EndFunc   ;==>_MutexExists

;Function for getting HWND from PID
Func _GetHwndFromPID($PID)
	YTS_EventLog("Func _GetHwndFromPID(" & $PID & ")", "", " 7")
	$hWnd = 0
	$winlist = WinList()
	Do
		For $i = 1 To $winlist[0][0]
			If $winlist[$i][0] <> "" Then
				$iPID2 = WinGetProcess($winlist[$i][1])
				If $iPID2 = $PID Then
					$hWnd = $winlist[$i][1]
					ExitLoop
				EndIf
			EndIf
		Next
	Until $hWnd <> 0
	Return $hWnd
EndFunc   ;==>_GetHwndFromPID

;===============================================================================
; Description:			If commandline arguements are present, this function is called
;						which then handles the commandline arguements appropriately
; Parameter(s):			NULL
; Requirement(s):		NULL
; Return Value(s):		NULL
; Author(s):            YTS_Jim
; Note(s):
;===============================================================================
Func _cmdline()
	YTS_EventLog("FUNC - _cmdline()", "", "7")
	Local $Local_loop = 0
	Do
		;ConsoleWrite("$cmdline[0] = " & $cmdline[0] & "$local_loop = " & $Local_loop & @CRLF)
		YTS_EventLog("$cmdline[0] = " & $cmdline[0] & "$local_loop = " & $Local_loop, $YTS_EventDisplay, "8")
		$Local_loop = $Local_loop + 1
		YTS_EventLog("$cmdline[" & $Local_loop & "] = " & $cmdline[$Local_loop], "", "7")
		Switch StringLower($cmdline[$Local_loop])
			Case "/?", "-help", "-h"
				YTS_EventLog("CMDLINE - HELP Arguement found", $YTS_EventDisplay, 4)
				$HelpMsg &= " - - - Help - - - " & @CRLF
				$HelpMsg &= "params : " & @CRLF
				$HelpMsg &= "  -startup X   : used to sleep for X seconds on application startup (great to allow slower computers to start all needed drivers and services)" & @CRLF
				$HelpMsg &= "  -debuglevel X: Sets the debuglevel to X for logging output" & @CRLF
				$HelpMsg &= "  -debuglog    : Sets the debuglog to 1 (regardless of INI value)." & @CRLF
				$HelpMsg &= "  -elevate     : runs this application in an elevated mode (for Vista+)" & @CRLF
				$HelpMsg &= "  -rerun       : for future" & @CRLF
				$HelpMsg &= "  -help        : Show this help" & @CRLF
				$HelpMsg &= " - - - -  - - - - " & @CRLF
				ConsoleWrite($HelpMsg)
				;				ConsoleWriteError($HelpMsg)
				YTS_EventLog("HELP = " & $HelpMsg, $YTS_EventDisplay, 4)
			Case "/elevate", "-elevate", "/e", "-e"
				YTS_EventLog("CMDLINE - ReRun Arguement found", $YTS_EventDisplay, 4)
			Case "/rerun", "-rerun", "/r", "-r"
				YTS_EventLog("CMDLINE - ReRun Arguement found", $YTS_EventDisplay, 4)
			Case "/debuglog", "-debuglog", "/log", "-log"
				YTS_EventLog("CMDLINE - DebugLog Arguement found", $YTS_EventDisplay, 4)
				$INI_DebugLog = 1
			Case "/debuglevel", "-debuglevel", "/dl", "-dl"
				YTS_EventLog("CMDLINE - DebugLevel Arguement found", $YTS_EventDisplay, 4)
				If $cmdline[$Local_loop + 1] <> "" And $cmdline[$Local_loop + 1] < 10 And $cmdline[$Local_loop + 1] > 1 Then
					$DebugLevel = $cmdline[$Local_loop + 1]
					$Local_loop = $Local_loop + 1
				Else
					$DebugLevel = 5
				EndIf
				YTS_EventLog("CMDLINE - DebugLevel set to: " & $DebugLevel, $YTS_EventDisplay, 4)
			Case "startup", "-startup", "/startup"
				YTS_EventLog("CMDLINE - STARTUP Arguement found", "", "4")
				$ConnectionState = "Sleep"
				_TrayIconState($ConnectionState)
				If $Local_loop + 1 <> "" Then
					YTS_EventLog("CMDLINE - STARTUP - Sleeping for: '" & $cmdline[$Local_loop + 1] & "' Seconds", "", "9")
					TrayTip($INI_RasDialerTitle & " Control", "Sleeping for " & $cmdline[$Local_loop + 1] & " seconds ...", 10)
					Sleep($cmdline[$Local_loop + 1] * 1000)
					$Local_loop = $Local_loop + 1
				Else
					YTS_EventLog("CMDLINE - STARTUP - Sleeping for: '60' Seconds (no time given)", "", "9")
					TrayTip($INI_RasDialerTitle & " Control", "Sleeping for 60 seconds ...", 10)
					Sleep(60000)
				EndIf
			Case Else
				$YTS_EventDisplay = YTS_EventLog("Cmdline Arguements not recognised", $YTS_EventDisplay, "7")
				;				TrayTip(_Translate($V2M_GUI_Language, "TRAYTIP_APP_START_TITLE", "APP_START_TITLE"), _Translate($V2M_GUI_Language, "TRAYTIP_APP_START_LINE1", "") & @CR & _Translate($V2M_GUI_Language, "TRAYTIP_APP_START_LINE2", ""), 10)
		EndSwitch
		Sleep(100)
	Until $Local_loop >= $cmdline[0]
EndFunc   ;==>_cmdline


Func _GetNetworkConnect()
	$YTS_EventDisplay = YTS_EventLog("Func _GetNetworkConnect()", $YTS_EventDisplay, "7")
	;http://www.autoitscript.com/forum/index.php?showtopic=85457
	Local Const $NETWORK_ALIVE_LAN = 0x1 ;net card connection
	Local Const $NETWORK_ALIVE_WAN = 0x2 ;RAS (internet) connection
	;    Local Const $NETWORK_ALIVE_AOL = 0x4  ;AOL

	Local $aRet, $iResult

	$aRet = DllCall("sensapi.dll", "int", "IsNetworkAlive", "int*", 0)

	If BitAND($aRet[1], $NETWORK_ALIVE_LAN) Then $iResult &= "LAN"
	If BitAND($aRet[1], $NETWORK_ALIVE_WAN) Then $iResult &= "WAN"
	;    If BitAND($aRet[1], $NETWORK_ALIVE_AOL) Then $iResult &= "AOL"

	Return $iResult
EndFunc   ;==>_GetNetworkConnect

Func _TrayIconState($LocalAppState = "")
	YTS_EventLog("Func _TrayIconState(" & $LocalAppState & ")", "", "7")
	;change the ICON
	If $LocalAppState = "" Then
		; this is the icon for startup
		_ChangeTrayIcon("icon")
	ElseIf $LocalAppState = "Sleep" Then
		; this is the icon while sleeping
		_ChangeTrayIcon("icon")
	ElseIf $LocalAppState = "NO" Then
		;
		_ChangeTrayIcon("red")
	ElseIf $LocalAppState = "Dialing" Then
		; this is the icon while dialing
		_ChangeTrayIcon("orange")
	ElseIf $LocalAppState = "DialFailed" Then
		; this is the icon while dialfailed
		_ChangeTrayIcon("red")
	ElseIf $LocalAppState = "Connected" Then
		;
		_ChangeTrayIcon("green")
		;		TraySetToolTip("SecureTech.com.au " & @ScriptName & " - Connected " & $Hours & ":" & $Mins)
		;		If $INI_DisableTips <> "1" Then
		;			ToolTip($INI_RasDialerTitle & " - Connected for " & $Hours & " Hours, " & $Mins & " Minutes")
		;			Sleep(2000)
		;			ToolTip("")
		;		EndIf
		;		;		TraySetState(1 + 8)	;1 = Shows the tray icon (default), 2 = Destroys/Hides the tray icon, 4 = Flashes the tray icon, 8 = Stops tray icon flashing, 16 = Resets the icon to the defaults (no flashing, default tip text)
	EndIf


	;Change the TRAYTIP
	;	If @Compiled And $INI_DisableTips <> "1" Then
	If $INI_DisableTips <> "1" Then
		If $LocalAppState = "" Then
			TraySetToolTip("SecureTech.com.au " & @ScriptName & " - " & FileGetVersion(@ScriptFullPath))
			TrayTip("", "", 0)
		ElseIf $LocalAppState = "Sleep" Then
			TraySetToolTip("SecureTech.com.au " & @ScriptName & " - Sleeping")
		ElseIf $LocalAppState = "NO" Then
			;
		ElseIf $LocalAppState = "Dialing" Then
			;
			_ChangeTrayIcon("orange")
			TrayTip($INI_RasDialerTitle, "Dialing '" & $INI_DialupName & "' Connection ...", 10)
		ElseIf $LocalAppState = "DialFailed" Then
			;
			TrayTip($INI_RasDialerTitle & " Control", $INetCon, 10)
			Sleep(5000)
			TrayTip($INI_RasDialerTitle & " Control", "", 10)
		ElseIf $LocalAppState = "Connected" Then
			;
		EndIf
	Else
		Opt("TrayIconDebug", 1) ;If enabled shows the current script line in the tray icon tip to help debugging.		0 = no debug information (default)	1 = show debug
	EndIf
	;	TraySetState(4)
EndFunc   ;==>_TrayIconState