@echo off
title YTS_Backup Started @ %DATE% %TIME%
color 80
cls

:: ############################################
:: ####    the directory and drive vars    ####
:: ####     change these to your needs     ####
:: ############################################
:: Setting Debug=1 will make more information echo to the screen, making it easier to find problems.
set Debug=1
:: The ScriptDir is the directory path of this script
set ScriptDir=X:\YTS_Backup_Script
:: The ScriptDrive is the drive letter this script is located in
set ScriptDrive=X:
:: The BackupDir is location to copy your Backups to. UNC paths not supported yet
set BackupDir=X:\Client_Files\JDs_Toshi
:: The BackupDrive is the drive letter the Mirror are to be located in
set BackupDrive=X:
:: The MirrorDir is location to place all mirrored Files. UNC paths not supported yet
set MirrorDir=X:\Client_Files\JDs_Toshi\Mirror
:: The MirrorDrive is the drive letter the Mirror are to be located in
set MirrorDrive=X:

:: #### THIS will log all output from the copy process to txt files for later review.
:: Enable this for Debug Logging of output to text files
set LogOutput=1

robocopy /? >> NUL
if %Debug% == 1 echo !ERRORLEVEL!
rem IF NOT ERRORLEVEL 0 GOTO robocopynotexist
IF ERRORLEVEL 16 GOTO robocopyexists

rem IF EXIST robocopy.exe goto robocopyexists
:robocopynotexist
set copyapp=xcopy
goto finishcopyapp
:robocopyexists
set copyapp=robocopy
:finishcopyapp

:: ############################################
:: ####   echo Setting Time and date vars  ####
:: ####       setup date and time vars     ####
:: ############################################
set hour=%time:~0,2%
if "%hour:~0,1%"==" " set hour=0%time:~1,1%
set NowTime=%hour%_%time:~3,2%_%time:~6,2%
set NowDate=%date:~10,4%_%date:~4,2%_%date:~7,2%

if %%1 == M goto MirrorOnly
if %%1 == B goto SkipQuestions

:: ############################################
:: ####  Tell the user what this script is ####
:: ####  Then ask if they want to continue ####
:: ############################################
echo This Script will Mirror or Backup files
echo from selected Dirs to %MirrorDir%
echo.
echo Close this window if you don't want to continue
echo.
SET /P Continue=Do you want to Run this script? [y/N]
IF /I "%Continue%"=="N" goto MirrorAborted
cls
echo.

echo Do you want to Backup or Mirror the files
echo.
echo Backup Creates a completely new copy of the files (within a dated directory)
echo Mirroring Simply updates changes to files (faster)
echo.
SET /P Continue=Do you want to Backup or Mirror? [B/M]
IF /I "%Continue%"=="M" goto MirrorOnly
cls
echo.

:SkipQuestions

if %Debug% == 1 echo DEBUG - ###  Backup Started @ %DATE% %TIME%  ###
if %Debug% == 1 pause

:: #### change this setting if you wish to change where the logs get put  ####
:: The LogDir is for future use (no logfiles are created at present.
set LogDir=%BackupDir%

if %Debug% == 1 echo DEBUG - change into the sysBackup drive (%BackupDrive%)
%BackupDrive%

if %Debug% == 1 echo DEBUG - change into the Backups dir (%BackupDir%)
cd %BackupDir%
rem if %Debug% == 1 dir

if not exist %NowDate%\NUL goto _NowDate_NotExists
rem Create the %NowDate%_%NowTime% directory
if %Debug% == 1 echo DEBUG - %MirrorDir%\%NowDate% directory exists, so ...
if %Debug% == 1 echo DEBUG - set the NOW to %NowDate%_%NowTime%  (YYYY_MM_DD_HH_MM_SS)
set NOW=%NowDate%_%NowTime%
goto _NowDate_time

:_NowDate_NotExists
rem Create the %NowDate% directory
if %Debug% == 1 echo DEBUG - %MirrorDir%\%NowDate% directory doesn't exist, so ...
if %Debug% == 1 echo DEBUG - set the NOW variable to %NowDate% (YYYY_MM_DD)
set NOW=%NowDate%
:_NowDate_time

if %Debug% == 1 echo DEBUG - Make the %MirrorDir%\%NOW% dir to write all files to
if not %copyapp% == robocopy md %MirrorDir%\%NOW%


rem the MirrorDir is now the directory created above, so we use that from now on
set MirrorDir=%MirrorDir%\%NOW%
if not exist %LogDir%\NUL goto _LogDir_NotExists
if %Debug% == 1 echo DEBUG - %LogDir%\ exists ...
goto _LogDir_exists
:_LogDir_NotExists
if %Debug% == 1 echo DEBUG - Making %LogDir%
md %LogDir%
:_LogDir_exists

echo.
echo Lets start Copying files to %BackupDir%
echo.
goto skipDir
:MirrorOnly
set LogDir=%BackupDir%

if %Debug% == 1 echo DEBUG - change into the sysMirror drive (%MirrorDrive%)
%MirrorDrive%

if %Debug% == 1 echo DEBUG - change into the Mirrors dir (%MirrorDir%)
cd %MirrorDir%
rem if %Debug% == 1 dir
:: change to the scriptdrive and script dir
%ScriptDrive%
cd %ScriptDir%

echo.
echo Lets start Copying files to %MirrorDir%
echo.
:skipDir


setlocal enabledelayedexpansion
setLocal EnableDelayedExpansion

set /A Counter=0
set /a N=0
If %Debug% == 1 echo DEBUG - Initial value of Counter: %Counter%

rem count the number of Mirror files and read the filename into
for %%f in (*.mir) do (
	title YTS_Backup - Running Mirror script: %%f
	If %Debug% == 1 echo.
	rem increment the counter, so we know how many Mirror files we have read.
	set /A Counter=!Counter!+1
	If %Debug% == 1 echo DEBUG - Current value of Counter: !Counter!
	if %Debug% == 1 echo DEBUG - Mirror file found: "%%f"
	for /f "tokens=* delims= " %%a in (%%f) do (
	rem if %Debug% == 1 echo DEBUG - a is : %%a
		set /a N+=1
		set v!N!=%%a
	)
	set N=0
	set SourceDir=!v1!
	set DestName=!v2!
	rem if %Debug% == 1 echo DEBUG - xcopy "!SourceDir!" "%ScriptDrive%\!DestName!" /S /Q /R /H /Y /I /v /c
	if %Debug% == 1 echo DEBUG - SourceDir = !SourceDir!
	if %Debug% == 1 echo DEBUG - DestName = !DestName!


	rem using xcopy
	if %copyapp% == xcopy (
		if %Debug% == 1 echo DEBUG - using xcopy method 
		if %Debug% == 1 pause
		if not %LogOutput%==1 xcopy "!SourceDir!" "%MirrorDir%\!DestName!" /S /Q /R /H /Y /I /v /c
		if %LogOutput%==1 xcopy "!SourceDir!" "%MirrorDir%\!DestName!" /S /Q /R /H /Y /I /v /c > %LogDir%\%NowDate%_%NowTime%_%%f.txt
		echo Mirror of "!SourceDir!" to "%MirrorDir%\!DestName!" Commencing ...
	)


	rem using robocopy
	if %copyapp% == robocopy (
		if %Debug% == 1 echo DEBUG - using robocopy method
		if %Debug% == 1 pause
		if not %LogOutput%==1 robocopy "!SourceDir!" "%MirrorDir%\!DestName!" /MIR /W:2 /R:10
		if %LogOutput%==1 robocopy "!SourceDir!" "%MirrorDir%\!DestName!" /MIR /W:2 /R:10 > %LogDir%\%NowDate%_%NowTime%_%%f.txt
		echo Mirroring of "!SourceDir!" to "%MirrorDir%\!DestName!" Commencing ...
	)


rem :donecopying

	rem if ERRORLEVEL == 0 (echo !DestName! files where copied successfully) ELSE (echo copying of !DestName! files failed)

rem			rem reset the variables after use (so if next one fails, it doesn't copy last one
if %Debug% == 1 pause
)

echo.
echo.
echo Finished!
echo We executed !Counter! Mirror routines from the .mir files
echo.
goto Finished
:MirrorAborted
echo.
echo Mirror was canceled
pause
:Finished
%ScriptDrive%
cd %ScriptDir%
:EOF
title 